/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.ipv6;

import ibm.nways.ipv6.IPv6Address;
import ibm.nways.jdm.common.IPAddress;
import java.io.Serializable;

public class IPv4v6Address
implements Serializable {
    public static final int NONE = 0;
    public static final int IPV4 = 4;
    public static final int IPV6 = 6;
    public static final int IPV6routeV4 = 7;
    public static final int IPV6embedV4 = 8;
    private int type;
    private IPAddress ipV4address;
    private IPv6Address ipV6address;

    public int getType() {
        return this.type;
    }

    public IPv4v6Address(IPAddress iPAddress) {
        this.type = 4;
        this.ipV4address = new IPAddress(iPAddress);
    }

    public IPv4v6Address(IPv6Address iPv6Address) {
        this.type = 6;
        this.ipV6address = new IPv6Address(iPv6Address);
    }

    public IPv4v6Address(int n) {
        this.type = 4;
        this.ipV4address = new IPAddress(n);
    }

    public IPv4v6Address(byte[] byArray, int n) {
        int n2 = byArray.length - n;
        if (n2 == 4) {
            this.type = 4;
            this.ipV4address = new IPAddress(byArray, n);
            return;
        }
        if (n2 == 16) {
            this.type = 6;
            this.ipV6address = new IPv6Address(byArray, n);
            return;
        }
        this.type = 0;
    }

    public IPv4v6Address(String string) {
        if (string.indexOf(":") > -1) {
            this.type = 6;
            this.ipV6address = new IPv6Address(string);
            return;
        }
        if (string.indexOf(".") > -1) {
            this.type = 4;
            this.ipV4address = new IPAddress(string);
            return;
        }
        this.type = 0;
    }

    public String toString() {
        String string = null;
        switch (this.type) {
            case 4: {
                string = this.ipV4address.toString();
                break;
            }
            case 6: {
                string = this.ipV6address.toString();
                break;
            }
        }
        return string;
    }

    public String getIpAddress() {
        return this.toString();
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[4];
        switch (this.type) {
            case 4: {
                byArray = this.ipV4address.getBytes();
                break;
            }
            case 6: {
                byArray = this.ipV6address.getBytes();
                break;
            }
        }
        return byArray;
    }

    public byte[] getBytes(int n) {
        byte[] byArray = null;
        if (this.type == 0) {
            return byArray;
        }
        if (n == 4) {
            if (this.type == 4) {
                byArray = this.ipV4address.getBytes();
            } else if (this.type == 6) {
                byte[] byArray2 = new byte[4];
                byte[] byArray3 = this.ipV6address.getBytes();
                byArray2[0] = byArray3[12];
                byArray2[1] = byArray3[13];
                byArray2[2] = byArray3[14];
                byArray2[3] = byArray3[15];
                byArray = byArray2;
            }
        } else if (this.type == 6) {
            byArray = this.ipV6address.getBytes();
        } else if (this.type == 4) {
            byte[] byArray4 = this.ipV4address.getBytes();
            byte[] byArray5 = new byte[16];
            byArray5[12] = byArray4[0];
            byArray5[13] = byArray4[1];
            byArray5[14] = byArray4[2];
            byArray5[15] = byArray4[3];
            if (n == 7 || n == 6) {
                byArray = byArray5;
            } else if (n == 8) {
                byArray5[10] = -1;
                byArray5[11] = -1;
                byArray = byArray5;
            }
        }
        return byArray;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof String) {
            IPv4v6Address iPv4v6Address = new IPv4v6Address((String)object);
            bl = iPv4v6Address.equals(this);
        } else if (object instanceof IPv4v6Address) {
            if (((IPv4v6Address)object).getType() == this.type) {
                byte[] byArray = this.getBytes();
                byte[] byArray2 = ((IPv4v6Address)object).getBytes();
                boolean bl2 = true;
                try {
                    int n = 0;
                    while (n < byArray.length) {
                        if (byArray[n] != byArray2[n]) {
                            bl2 = false;
                            break;
                        }
                        ++n;
                    }
                    bl = bl2;
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
        } else if (object instanceof IPAddress) {
            if (this.type == 4) {
                bl = this.ipV4address.equals(object);
            }
        } else if (object instanceof IPv6Address && this.type == 6) {
            bl = this.ipV6address.equals((IPv6Address)object);
        }
        return bl;
    }
}

